package kom.itbeankit.nw.ethernet;

import java.awt.*;
import kom.itbeankit.common.vcr.ClkEvent;
import kom.itbeankit.common.vcr.ClkListener;

public class BusElement extends java.awt.Container implements EthernetInterface,ClkListener
{
    
	public BusElement()
	{
		//{{INIT_CONTROLS
		setLayout(new BorderLayout(0,0));
		setSize(20,20);
		panel = new java.awt.Panel();
		panel.setLayout(null);
		panel.setBounds(0,0,20,20);
		panel.setBackground(new Color(12632256));
		add("Center", panel);
		//}}
		panel.setBackground(new Color(DATA_COLOR_IDLE));
		newStatus = new BusElementStatus();
		oldStatus = new BusElementStatus();
		dataType = DATA_TYPE_IDLE;
		dark = false;
	}
	//{{DECLARE_CONTROLS
	java.awt.Panel panel;
	//}}

	public void paint(Graphics g){
	    super.paint(g);
	    panel.setSize(getSize());
	}

    public void reset(){
        oldStatus = new BusElementStatus();
        newStatus = new BusElementStatus();
        dark = false;
    }
    
    
    public void clkReceived(ClkEvent e){
        //fire data events depending on old status
        //these events will change new status in listeners
        if(e.isRisingEdge()){
            processOldStatus();    
        }
        //copy new status in old status
        //and reset new status
        else{
            oldStatus.setStatus(newStatus);
            newStatus = new BusElementStatus();
        }
    }
    
    //sets datatype (and background color)
    //and fires events to neighbors
    // according to oldstatus
    private void processOldStatus(){
        setDataType(oldStatus.getDataType());
        setColor();
        for(int i=0; i<dataListeners.size();i++){
            
            DataListener dl = (DataListener)dataListeners.elementAt(i);
        
            if(oldStatus.fromLeftDataEvent != null){
                DataEvent de = new DataEvent(this,oldStatus.fromLeftDataEvent);
                dl.dataToRight(de);         
                dl.dataToTop(de);         
                dl.dataToBottom(de);
                oldStatus.fromLeftDataEvent = null;
            }
            if(oldStatus.fromRightDataEvent != null){
                DataEvent de = new DataEvent(this,oldStatus.fromRightDataEvent);
                dl.dataToLeft(de);         
                dl.dataToTop(de);         
                dl.dataToBottom(de); 
                oldStatus.fromRightDataEvent = null;
            }
            if(oldStatus.fromTopDataEvent != null){
                DataEvent de = new DataEvent(this,oldStatus.fromTopDataEvent);
                dl.dataToRight(de);         
                dl.dataToLeft(de);         
                dl.dataToBottom(de);
                oldStatus.fromTopDataEvent = null;
            }
            if(oldStatus.fromBottomDataEvent != null){
                DataEvent de = new DataEvent(this,oldStatus.fromBottomDataEvent);
                dl.dataToRight(de);         
                dl.dataToTop(de);         
                dl.dataToLeft(de);
                oldStatus.fromBottomDataEvent = null;
            }
        }
    
    }

    public synchronized void addDataListener(DataListener lis)
    {
        dataListeners.addElement(lis);
    }
    
    public synchronized void removeDataListener(DataListener lis)
    {
        dataListeners.removeElement(lis);
    }
    
   /* protected void processDataEvent(DataEvent e)
    {
    }*/

    public void dataFromRight(DataEvent e){
        if(newStatus.fromRightDataEvent!=null)
            e = new DataEvent(this,DATA_TYPE_COLLISION,0,0,0,false,false);
        newStatus.fromRightDataEvent=e;
    }

    public void dataFromLeft(DataEvent e){
        if(newStatus.fromLeftDataEvent!=null)
            e = new DataEvent(this,DATA_TYPE_COLLISION,0,0,0,false,false);
        newStatus.fromLeftDataEvent=e;
    }

    public void dataFromTop(DataEvent e){
        if(newStatus.fromTopDataEvent!=null)
            e = new DataEvent(this,DATA_TYPE_COLLISION,0,0,0,false,false);
        newStatus.fromTopDataEvent=e;
    }
    
    public void dataFromBottom(DataEvent e){
        if(newStatus.fromBottomDataEvent!=null)
            e = new DataEvent(this,DATA_TYPE_COLLISION,0,0,0,false,false);
        newStatus.fromBottomDataEvent=e;
    }
    
    private void setColor(){
		//if (!((this.dataType==dataType)&&(this.dataType==DATATYPE_IDLE)))
		{
			int colorCode = 0;
			//set the background color according to data type
			if(dark){
    			switch(dataType){
    			    case DATA_TYPE_IDLE:
    		            colorCode = DATA_COLOR_IDLE;
    		            break;
    			    case DATA_TYPE_DATA:
    		            colorCode = DATA_COLOR_DATA_DARK;
    		            break;
    			    case DATA_TYPE_PADDING:
    		            colorCode = DATA_COLOR_PADDING_DARK;
    		            break;
    			    case DATA_TYPE_COLLISION:
    		            colorCode = DATA_COLOR_COLLISION_DARK;
    		            break;
    			    default:
    			}
			}
			else{
    			switch(dataType){
    			    case DATA_TYPE_IDLE:
    		            colorCode = DATA_COLOR_IDLE;
    		            break;
    			    case DATA_TYPE_DATA:
    		            colorCode = DATA_COLOR_DATA;
    		            break;
    			    case DATA_TYPE_PADDING:
    		            colorCode = DATA_COLOR_PADDING;
    		            break;
    			    case DATA_TYPE_COLLISION:
    		            colorCode = DATA_COLOR_COLLISION;
    		            break;
    			    default:
    			}
			}
			    
		    panel.setBackground(new Color(colorCode));
		}
    }
	
	public void setDataType(int dataType)
	{
        //int oldValue = this.dataType;
        //int newValue = dataType;
        if(dataType!=DATA_TYPE_IDLE)
            dark = !dark;
        this.dataType = dataType;
        //changes.firePropertyChange("dataType" ,oldValue, newValue);
	}
	

	public int getDataType()
	{
		return this.dataType;
	}

	static public void main(String args[])
	{
		class DriverFrame extends java.awt.Frame {
			public DriverFrame() {
				addWindowListener(new java.awt.event.WindowAdapter() {
					public void windowClosing(java.awt.event.WindowEvent event)
					{
						dispose();	  // free the system resources
						System.exit(0); // close the application
					}
				});
				this.setLayout(new java.awt.BorderLayout());
				this.setSize(300,300);
				this.add(new BusElement());
			}
		}

		new DriverFrame().show();
	}

	private symantec.itools.beans.PropertyChangeSupport changes = new symantec.itools.beans.PropertyChangeSupport(this);
	protected int dataType;
    protected boolean dark;
    protected BusElementStatus newStatus;
    protected BusElementStatus oldStatus;
    private java.util.Vector dataListeners = new java.util.Vector();
}